<?php
session_start();
require_once 'config.php';

// Verifica se já está logado
if (isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit;
}

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $senha = $_POST['senha'];

    // Busca o usuário admin
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = ? AND tipo = 'admin'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    // Verifica a senha (usando password_verify para segurança)
    if ($user && password_verify($senha, $user['senha'])) {
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['admin_nome'] = $user['nome'];
        header("Location: index.php");
        exit;
    } else {
        $erro = "E-mail ou senha incorretos!";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Admin TikTokShop</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-900 flex items-center justify-center h-screen font-[Inter]">
    
    <div class="bg-white p-8 rounded-lg shadow-xl w-96">
        <div class="text-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Acesso Restrito</h1>
            <p class="text-gray-500 text-sm">Gerenciamento TikTokShop</p>
        </div>

        <?php if($erro): ?>
            <div class="bg-red-100 text-red-700 p-3 rounded mb-4 text-sm text-center">
                <?= $erro ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-4">
                <label class="block text-gray-700 text-sm font-bold mb-2">E-mail</label>
                <input type="email" name="email" required class="w-full p-3 border rounded focus:outline-none focus:border-pink-500" placeholder="Digite o seu e-mail">
            </div>
            <div class="mb-6">
                <label class="block text-gray-700 text-sm font-bold mb-2">Senha</label>
                <input type="password" name="senha" required class="w-full p-3 border rounded focus:outline-none focus:border-pink-500" placeholder="••••••••">
            </div>
            <button type="submit" class="w-full bg-[#ff0050] text-white font-bold py-3 rounded hover:bg-pink-700 transition duration-200">
                Entrar no Sistema
            </button>
        </form>
        
        <p class="text-center text-xs text-gray-400 mt-6">Sistema Seguro v1.0</p>
    </div>

</body>
</html>