<?php
session_start();

// 1. CONEXÃO E SEGURANÇA
// Tenta carregar configs de vários locais para garantir
$paths = ['config.php', '../config.php'];
foreach ($paths as $path) { if (file_exists($path)) { require_once $path; break; } }

// --- CORREÇÃO DA SESSÃO ---
// Tenta identificar o ID do usuário logado em várias variáveis comuns
$idUsuario = $_SESSION['usuario_id'] ?? $_SESSION['id'] ?? $_SESSION['admin_id'] ?? null;

// Se não achou nenhum ID na sessão
if (!$idUsuario) {
    // Debug para você ver o que está acontecendo
    echo "<div style='padding:20px; font-family:sans-serif; text-align:center;'>";
    echo "<h1>Acesso Negado</h1>";
    echo "<p>Não foi possível identificar sua sessão de login.</p>";
    echo "<p>Por favor, faça login no seu <strong>Painel Admin Principal</strong> primeiro.</p>";
    echo "<a href='login.php' style='background:#ff0050; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>Ir para Login</a>";
    exit;
}

// ==============================================================================
// 2. VERIFICAÇÃO DE PERMISSÃO (COM AUTO-CORREÇÃO DO BANCO)
// ==============================================================================
try {
    // Tenta buscar o nível e nome do usuário
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$idUsuario]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Se a coluna 'nivel' não existir no array retornado (mesmo que a query não falhe), trata aqui
    // Mas geralmente a query falha antes se a coluna não existe no SELECT explícito.
    // Vamos forçar um check se a coluna existe na estrutura se der erro.

    // Verifica permissão se o usuário foi encontrado
    if ($user) {
        $nivelUser = $user['nivel'] ?? 'aluno'; // Fallback se vier vazio
        
        if ($nivelUser !== 'admin' && $nivelUser !== 'administrador') {
            // Se não for admin, mostra erro amigável e botão de "Forçar Admin" (útil para o dono)
            echo "<div style='padding:40px; font-family:sans-serif; text-align:center; max-width:600px; margin:0 auto;'>";
            echo "<h1 style='color:#ff0050'>Permissão Insuficiente</h1>";
            echo "<p>O usuário <strong>" . ($user['nome'] ?? 'Desconhecido') . "</strong> não está marcado como 'admin'.</p>";
            
            // Botão de Emergência para o Dono (Detecta pelo email Pataíba)
            $email = $user['email'] ?? '';
            if (strpos($email, 'pataiba') !== false || strpos($email, 'admin') !== false || strpos($email, 'thelike') !== false) {
                echo "<hr style='margin:20px 0; border:0; border-top:1px solid #eee;'>";
                echo "<p>Detectamos que você é o dono (<strong>$email</strong>).</p>";
                echo "<form method='POST'><button type='submit' name='force_admin' value='1' style='background:#222; color:white; padding:12px 24px; border:none; border-radius:8px; font-weight:bold; cursor:pointer;'>👑 Tornar-me Admin Agora</button></form>";
                
                // Processa o clique no botão
                if (isset($_POST['force_admin'])) {
                    $pdo->prepare("UPDATE usuarios SET nivel = 'admin' WHERE id = ?")->execute([$idUsuario]);
                    echo "<script>alert('Sucesso! Você agora é Admin. Recarregando...'); window.location.reload();</script>";
                }
            }
            echo "</div>";
            exit;
        }
    } else {
        die("Usuário não encontrado no banco de dados (ID: $idUsuario).");
    }

} catch (PDOException $e) {
    
    // --- AUTO-CORREÇÃO DE "COLUNA NÃO ENCONTRADA" (ERRO 1054) ---
    if (strpos($e->getMessage(), '1054') !== false || strpos($e->getMessage(), 'Unknown column') !== false) {
        
        try {
            // 1. Cria a coluna 'nivel' que falta
            $pdo->exec("ALTER TABLE usuarios ADD COLUMN nivel VARCHAR(20) DEFAULT 'aluno'");
            
            // 2. Transforma o usuário atual em Admin para não travar
            $pdo->prepare("UPDATE usuarios SET nivel = 'admin' WHERE id = ?")->execute([$idUsuario]);
            
            // 3. Recarrega a página automaticamente
            echo "<script>window.location.reload();</script>";
            exit;
            
        } catch (Exception $ex) {
            die("<h1>Erro ao corrigir banco automaticamente:</h1><p>" . $ex->getMessage() . "</p>");
        }
        
    } else {
        // Outro erro qualquer
        die("Erro crítico no banco: " . $e->getMessage());
    }
}

// ==============================================================================
// 3. PROCESSAMENTO DE AÇÕES (POST)
// ==============================================================================

// A. CRIAR CUPOM
if (isset($_POST['acao']) && $_POST['acao'] == 'criar_cupom') {
    $titulo = $_POST['titulo'];
    $codigo = strtoupper($_POST['codigo']);
    $desc   = $_POST['descricao'];
    $cor    = $_POST['cor']; // 'white' ou 'pink'
    
    $stmt = $pdo->prepare("INSERT INTO cupoms (titulo, descricao, codigo, cor_fundo, ativo) VALUES (?, ?, ?, ?, 1)");
    $stmt->execute([$titulo, $desc, $codigo, $cor]);
    $msg = "Cupom criado com sucesso!";
}

// B. EXCLUIR CUPOM
if (isset($_GET['deletar_cupom'])) {
    $id = (int)$_GET['deletar_cupom'];
    $pdo->prepare("DELETE FROM cupoms WHERE id = ?")->execute([$id]);
    header("Location: admin_afiliados.php?msg=Cupom Deletado");
    exit;
}

// ==============================================================================
// 4. BUSCAR DADOS PARA O DASHBOARD
// ==============================================================================

// KPI: Total de Comissões Pendentes (Saldo nas carteiras dos afiliados)
$totalComissoes = $pdo->query("SELECT SUM(saldo_afiliado) FROM usuarios")->fetchColumn();

// KPI: Total de Vendas por Afiliados
$totalVendasAfiliados = $pdo->query("SELECT SUM(total_vendas_afiliado) FROM usuarios")->fetchColumn();

// LISTA: Top 10 Afiliados
$topAfiliados = $pdo->query("
    SELECT u.nome, u.email, u.saldo_afiliado, u.total_vendas_afiliado, u.codigo_afiliado, n.nome as nivel_nome 
    FROM usuarios u
    LEFT JOIN afiliados_niveis n ON u.nivel_id = n.id
    WHERE u.codigo_afiliado IS NOT NULL 
    ORDER BY u.saldo_afiliado DESC 
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// LISTA: Cupons Ativos
$listaCupons = $pdo->query("SELECT * FROM cupoms ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Gestão de Afiliados</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 text-gray-800">

    <div class="flex min-h-screen">
        
        <!-- Sidebar Simples -->
        <aside class="w-64 bg-gray-900 text-white hidden md:block">
            <div class="p-6 font-bold text-xl tracking-tight">
                <span class="text-pink-500">TikTok</span> Shop Admin
            </div>
            <nav class="mt-6">
                <!-- Link de Voltar para seu Admin Principal (Ajuste o link se souber o nome do arquivo) -->
                <a href="javascript:history.back()" class="block py-3 px-6 text-gray-400 hover:text-white hover:bg-gray-800 transition">
                    <i class="fas fa-arrow-left mr-2"></i> Voltar ao Painel Principal
                </a>
                
                <a href="#" class="block py-3 px-6 bg-gray-800 border-r-4 border-pink-500 text-white font-medium">
                    <i class="fas fa-users mr-2"></i> Afiliados & Cupons
                </a>
                <a href="loja/index.php" target="_blank" class="block py-3 px-6 text-gray-400 hover:text-white hover:bg-gray-800 transition">
                    <i class="fas fa-store mr-2"></i> Ver Loja
                </a>
                <a href="painel_afiliado.php" target="_blank" class="block py-3 px-6 text-gray-400 hover:text-white hover:bg-gray-800 transition">
                    <i class="fas fa-mobile-alt mr-2"></i> Ver Painel Afiliado
                </a>
            </nav>
        </aside>

        <!-- Conteúdo Principal -->
        <main class="flex-1 p-8">
            
            <header class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Gestão de Parceiros</h1>
                    <p class="text-sm text-gray-500">Administre comissões e marketing da loja.</p>
                </div>
                <div class="flex items-center gap-4">
                    <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-xs font-bold">Admin Conectado: <?php echo explode(' ', $user['nome'] ?? 'Admin')[0]; ?></span>
                </div>
            </header>

            <?php if(isset($msg) || isset($_GET['msg'])): ?>
                <div class="bg-green-100 border border-green-200 text-green-700 px-4 py-3 rounded relative mb-6">
                    <strong class="font-bold">Sucesso!</strong>
                    <span class="block sm:inline"><?php echo $msg ?? $_GET['msg']; ?></span>
                </div>
            <?php endif; ?>

            <!-- KPIs -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <!-- Card 1 -->
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs text-gray-500 font-bold uppercase">Total a Pagar (Saldo)</p>
                            <h3 class="text-2xl font-bold text-gray-800 mt-1">R$ <?php echo number_format($totalComissoes ?? 0, 2, ',', '.'); ?></h3>
                        </div>
                        <div class="p-2 bg-pink-50 rounded-lg text-pink-500"><i class="fas fa-wallet"></i></div>
                    </div>
                </div>
                <!-- Card 2 -->
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs text-gray-500 font-bold uppercase">Vendas por Afiliados</p>
                            <h3 class="text-2xl font-bold text-gray-800 mt-1"><?php echo $totalVendasAfiliados ?? 0; ?></h3>
                        </div>
                        <div class="p-2 bg-blue-50 rounded-lg text-blue-500"><i class="fas fa-shopping-bag"></i></div>
                    </div>
                </div>
                <!-- Card 3 -->
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-100">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-xs text-gray-500 font-bold uppercase">Cupons Ativos</p>
                            <h3 class="text-2xl font-bold text-gray-800 mt-1"><?php echo is_array($listaCupons) ? count($listaCupons) : 0; ?></h3>
                        </div>
                        <div class="p-2 bg-purple-50 rounded-lg text-purple-500"><i class="fas fa-ticket-alt"></i></div>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                
                <!-- COLUNA 1: GESTÃO DE CUPONS -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-6 border-b border-gray-100 flex justify-between items-center">
                        <h2 class="font-bold text-lg">🎟️ Cupons da Loja</h2>
                        <button onclick="document.getElementById('formCupom').classList.toggle('hidden')" class="text-sm text-pink-600 font-bold hover:underline">+ Novo Cupom</button>
                    </div>
                    
                    <!-- Form Novo Cupom (Escondido por padrão) -->
                    <div id="formCupom" class="hidden bg-gray-50 p-6 border-b border-gray-100">
                        <form method="POST" class="grid gap-4">
                            <input type="hidden" name="acao" value="criar_cupom">
                            <div class="grid grid-cols-2 gap-4">
                                <input type="text" name="codigo" placeholder="CÓDIGO (Ex: NATAL10)" required class="p-2 border rounded uppercase font-bold">
                                <input type="text" name="titulo" placeholder="Título (Ex: Frete Grátis)" required class="p-2 border rounded">
                            </div>
                            <input type="text" name="descricao" placeholder="Descrição (Ex: Acima de R$ 100)" required class="p-2 border rounded">
                            <select name="cor" class="p-2 border rounded">
                                <option value="white">Fundo Branco (Padrão)</option>
                                <option value="pink">Fundo Rosa (Destaque)</option>
                            </select>
                            <button type="submit" class="bg-gray-900 text-white py-2 rounded font-bold hover:bg-black">Salvar Cupom</button>
                        </form>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm">
                            <thead class="bg-gray-50 text-gray-500">
                                <tr>
                                    <th class="p-4">Código</th>
                                    <th class="p-4">Detalhes</th>
                                    <th class="p-4">Ação</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                <?php if(is_array($listaCupons) && count($listaCupons) > 0): ?>
                                    <?php foreach($listaCupons as $cupom): ?>
                                    <tr>
                                        <td class="p-4 font-bold text-pink-600"><?php echo $cupom['codigo']; ?></td>
                                        <td class="p-4">
                                            <div class="font-medium"><?php echo $cupom['titulo']; ?></div>
                                            <div class="text-xs text-gray-500"><?php echo $cupom['descricao']; ?></div>
                                        </td>
                                        <td class="p-4">
                                            <a href="?deletar_cupom=<?php echo $cupom['id']; ?>" onclick="return confirm('Tem certeza?')" class="text-red-500 hover:text-red-700 font-bold text-xs">Excluir</a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="3" class="p-4 text-center text-gray-400">Nenhum cupom criado.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- COLUNA 2: RANKING DE AFILIADOS -->
                <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                    <div class="p-6 border-b border-gray-100">
                        <h2 class="font-bold text-lg">🏆 Top Afiliados</h2>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm">
                            <thead class="bg-gray-50 text-gray-500">
                                <tr>
                                    <th class="p-4">Afiliado</th>
                                    <th class="p-4 text-center">Nível</th>
                                    <th class="p-4 text-right">Vendas</th>
                                    <th class="p-4 text-right">Saldo</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                <?php if(is_array($topAfiliados) && count($topAfiliados) > 0): ?>
                                    <?php foreach($topAfiliados as $afil): ?>
                                    <tr>
                                        <td class="p-4">
                                            <div class="font-bold text-gray-800"><?php echo $afil['nome']; ?></div>
                                            <div class="text-xs text-gray-500"><?php echo $afil['email']; ?></div>
                                            <div class="text-[10px] text-pink-500 font-mono mt-0.5">REF: <?php echo $afil['codigo_afiliado']; ?></div>
                                        </td>
                                        <td class="p-4 text-center">
                                            <span class="bg-blue-100 text-blue-700 px-2 py-0.5 rounded text-xs font-bold">
                                                <?php echo $afil['nivel_nome'] ?? 'Iniciante'; ?>
                                            </span>
                                        </td>
                                        <td class="p-4 text-right font-medium"><?php echo $afil['total_vendas_afiliado']; ?></td>
                                        <td class="p-4 text-right font-bold text-green-600">R$ <?php echo number_format($afil['saldo_afiliado'], 2, ',', '.'); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr><td colspan="4" class="p-4 text-center text-gray-400">Nenhum afiliado encontrado.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="p-4 bg-gray-50 text-center border-t border-gray-100">
                        <button class="text-sm text-gray-500 font-medium hover:text-gray-800">Ver todos os afiliados</button>
                    </div>
                </div>

            </div>
        </main>
    </div>

</body>
</html>