<?php
session_start();
require_once 'config.php';

// Segurança: Só aluno logado pode mexer
if (!isset($_SESSION['aluno_id'])) { die(json_encode(['status' => 'erro'])); }

$aluno_id = $_SESSION['aluno_id'];
$acao = $_POST['acao'] ?? '';

// 1. MARCAR / DESMARCAR COMO CONCLUÍDA
if ($acao == 'toggle_conclusao') {
    $aula_id = $_POST['aula_id'];
    
    // Verifica se já existe
    $check = $pdo->prepare("SELECT id FROM progresso_aulas WHERE usuario_id = ? AND aula_id = ?");
    $check->execute([$aluno_id, $aula_id]);
    
    if ($check->rowCount() > 0) {
        // Se existe, remove (desmarcar)
        $pdo->prepare("DELETE FROM progresso_aulas WHERE usuario_id = ? AND aula_id = ?")->execute([$aluno_id, $aula_id]);
        echo json_encode(['status' => 'removido']);
    } else {
        // Se não existe, cria (marcar)
        $pdo->prepare("INSERT INTO progresso_aulas (usuario_id, aula_id) VALUES (?, ?)")->execute([$aluno_id, $aula_id]);
        echo json_encode(['status' => 'concluido']);
    }
}

// 2. ENVIAR COMENTÁRIO E NOTA
if ($acao == 'comentar') {
    $aula_id = $_POST['aula_id'];
    $nota = $_POST['nota'];
    $texto = strip_tags($_POST['comentario']); // Remove tags HTML por segurança
    
    if (!empty($texto)) {
        $stmt = $pdo->prepare("INSERT INTO comentarios_aulas (usuario_id, aula_id, nota, comentario) VALUES (?, ?, ?, ?)");
        $stmt->execute([$aluno_id, $aula_id, $nota, $texto]);
        
        // Retorna o HTML do comentário para aparecer na hora
        $data = date('d/m/Y');
        $nome = $_SESSION['aluno_nome'];
        $html = "
        <div class='bg-[#222] p-4 rounded-lg mb-3 border border-[#333] animate-fade-in'>
            <div class='flex justify-between items-start'>
                <div class='flex items-center gap-2'>
                    <div class='w-8 h-8 rounded-full bg-[#ff0050] flex items-center justify-center font-bold text-xs'>".strtoupper(substr($nome,0,1))."</div>
                    <div>
                        <p class='text-sm font-bold text-white'>$nome</p>
                        <div class='text-yellow-500 text-xs'>".str_repeat('★', $nota)."</div>
                    </div>
                </div>
                <span class='text-[10px] text-gray-500'>Agora</span>
            </div>
            <p class='text-gray-300 text-sm mt-2'>$texto</p>
        </div>";
        
        echo json_encode(['status' => 'sucesso', 'html' => $html]);
    }
}
?>