<?php
session_start();

// 1. CONEXÃO
$paths = ['config.php', 'tiktok/config.php'];
foreach ($paths as $path) { if (file_exists($path)) { require_once $path; break; }}
if (!isset($pdo)) { die("Erro de conexão."); }

// 2. SEGURANÇA
if (!isset($_SESSION['aluno_id'])) {
    die("Acesso negado. Faça login na área de membros.");
}

$aula_id = filter_input(INPUT_GET, 'aula', FILTER_VALIDATE_INT);
if (!$aula_id) { die("Aula não especificada."); }

// 3. BUSCA DADOS
$stmt = $pdo->prepare("SELECT * FROM aulas WHERE id = ?");
$stmt->execute([$aula_id]);
$aula = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$aula) { die("Aula não encontrada."); }

// Dados do Aluno para Marca D'água
$nome_aluno = $_SESSION['aluno_nome'];
$email_aluno = $_SESSION['email'] ?? 'Aluno'; // Ajuste conforme sua sessão
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Apostila - <?= htmlspecialchars($aula['nome']) ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&family=Merriweather:ital,wght@0,300;0,400;0,700;1,400&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* CONFIGURAÇÕES GERAIS */
        body {
            background-color: #525659; /* Fundo cinza de visualizador de PDF */
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif;
            -webkit-print-color-adjust: exact;
        }

        /* FOLHA A4 */
        .page {
            background: white;
            display: block;
            margin: 40px auto;
            margin-bottom: 40px;
            box-shadow: 0 0 20px rgba(0,0,0,0.5);
            max-width: 21cm; /* Largura A4 */
            min-height: 29.7cm; /* Altura A4 */
            padding: 2cm;
            position: relative;
            box-sizing: border-box;
        }

        /* CONTEÚDO */
        .header {
            border-bottom: 2px solid #ff0050;
            padding-bottom: 20px;
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logo { font-weight: 900; font-size: 24px; color: #000; letter-spacing: -1px; text-transform: uppercase; }
        .logo span { color: #ff0050; }
        
        h1 { font-family: 'Inter', sans-serif; font-weight: 800; font-size: 28px; color: #111; margin-bottom: 10px; line-height: 1.2; }
        .meta { color: #666; font-size: 12px; margin-bottom: 30px; text-transform: uppercase; letter-spacing: 1px; font-weight: bold; }

        .content {
            font-family: 'Merriweather', serif; /* Fonte boa para leitura longa */
            font-size: 16px;
            line-height: 1.8;
            color: #333;
            text-align: justify;
        }
        .content h2 { font-family: 'Inter', sans-serif; color: #ff0050; margin-top: 30px; font-size: 20px; }
        .content ul { margin-bottom: 20px; }
        .content li { margin-bottom: 8px; }
        .content img { max-width: 100%; height: auto; border-radius: 4px; margin: 20px 0; border: 1px solid #eee; }
        .content a { color: #ff0050; text-decoration: underline; }

        /* RODAPÉ DE SEGURANÇA (FIXO) */
        .watermark-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: #fff;
            border-top: 1px solid #eee;
            padding: 10px;
            text-align: center;
            font-size: 9px;
            color: #999;
            font-family: monospace;
            z-index: 999;
        }

        /* BOTÃO FLUTUANTE (APENAS TELA) */
        .fab-print {
            position: fixed;
            bottom: 30px;
            right: 30px;
            background: #ff0050;
            color: white;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(255, 0, 80, 0.4);
            cursor: pointer;
            z-index: 1000;
            transition: transform 0.2s;
            border: none;
            font-size: 24px;
        }
        .fab-print:hover { transform: scale(1.1); background: #d60043; }

        /* CONFIGURAÇÃO DE IMPRESSÃO */
        @media print {
            body { background: none; }
            .page { 
                margin: 0; 
                box-shadow: none; 
                width: 100%; 
                max-width: 100%; 
                min-height: auto; 
                padding: 0; /* Margens são controladas pelo @page */
            }
            .fab-print { display: none; } /* Esconde botão */
            
            /* Rodapé em todas as páginas */
            .watermark-footer {
                position: fixed;
                bottom: 0;
            }

            /* Quebras de página inteligentes */
            h2, h3 { page-break-after: avoid; }
            img { page-break-inside: avoid; }
        }

        @page {
            margin: 2cm;
        }
    </style>
</head>
<body>

    <!-- Botão de Imprimir/Salvar -->
    <button class="fab-print" onclick="window.print()" title="Salvar como PDF">
        <i class="fas fa-print"></i>
    </button>

    <div class="page">
        <div class="header">
            <div class="logo">THE<span>LIKE</span>.PRO</div>
            <div style="text-align: right; font-size: 10px; color: #888;">
                DOCUMENTO EXCLUSIVO<br>
                GERADO EM <?= date('d/m/Y') ?>
            </div>
        </div>

        <h1><?= $aula['nome'] ?></h1>
        <div class="meta">MATERIAL DE APOIO OFICIAL</div>

        <div class="content">
            <?php if(!empty($aula['descricao_texto'])): ?>
                <?= $aula['descricao_texto'] ?>
            <?php else: ?>
                <p><em>Nenhum conteúdo de texto disponível para esta aula.</em></p>
            <?php endif; ?>
        </div>
        
        <div style="margin-top: 50px; border-top: 1px dashed #ccc; padding-top: 20px; text-align: center;">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=<?= urlencode("https://" . $_SERVER['HTTP_HOST'] . "/area_aluno.php") ?>" alt="QR Code" style="width: 80px; margin: 0 auto; border:none;">
            <p style="font-size: 10px; color: #666; margin-top: 5px;">Escaneie para acessar a plataforma</p>
        </div>
    </div>

    <!-- MARCA D'ÁGUA DE SEGURANÇA (FIXA NO RODAPÉ) -->
    <div class="watermark-footer">
        LICENCIADO PARA: <strong><?= mb_strtoupper($nome_aluno) ?></strong> (<?= $email_aluno ?>) - CPF: ***.***.***-**<br>
        Este documento é pessoal e intransferível. A cópia ou distribuição é proibida. ID: <?= $_SESSION['aluno_id'] ?>-<?= $aula_id ?>
    </div>

</body>
</html>