<?php
// ATIVAR EXIBIÇÃO DE ERROS PARA DEBUG (REMOVER EM PRODUÇÃO)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
date_default_timezone_set('America/Sao_Paulo');

// ==============================================================================
// 1. CONEXÃO COM O BANCO DE DADOS
// ==============================================================================
$paths = ['config.php', '../config.php', '../../config.php'];
$config_loaded = false;
foreach ($paths as $path) {
    if (file_exists($path)) {
        require_once $path;
        $config_loaded = true;
        break;
    }
}
if (!$config_loaded) { die("Erro: config.php não encontrado."); }

if (!isset($pdo)) { die("Erro Crítico: Conexão com banco de dados falhou."); }

// === IMPORTAÇÃO DO ENVIADOR DE E-MAIL (CORREÇÃO DE CAMINHOS) ===
// Tenta carregar na mesma pasta ou na pasta pai
$email_script_paths = ['enviar_email_acesso.php', '../enviar_email_acesso.php', '../../enviar_email_acesso.php'];
$email_loaded = false;
foreach ($email_script_paths as $ep) {
    if (file_exists($ep)) {
        require_once $ep;
        $email_loaded = true;
        break;
    }
}

// ==============================================================================
// 2. DADOS DO PRODUTO
// ==============================================================================
$id_produto = $_GET['product_id'] ?? $_GET['id'] ?? 0;
$ref = $_GET['ref'] ?? $_COOKIE['afiliado_ref'] ?? null; // Rastreamento de Afiliado

$id_produto = (int)$id_produto;

try {
    $stmt = $pdo->prepare("SELECT * FROM produtos WHERE id = ?");
    $stmt->execute([$id_produto]);
    $produto = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Erro ao buscar produto: " . $e->getMessage());
}

if (!$produto) { die("Produto não encontrado."); }

// === DADOS DA LOJA ===
$logo_url = 'images/logo.jpg'; 
try {
    $stmt_loja = $pdo->prepare("SELECT * FROM config_loja WHERE id = 1");
    $stmt_loja->execute();
    $loja = $stmt_loja->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {}

// ==============================================================================
// 3. PROCESSAMENTO DE CURSO GRÁTIS (R$ 0,00)
// ==============================================================================
$erro_gratis = '';

if ($produto['preco_atual'] <= 0 && $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'free_checkout') {
    // CORREÇÃO: Usando filtros modernos
    $nome = filter_input(INPUT_POST, 'nome', FILTER_SANITIZE_SPECIAL_CHARS);
    $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
    $whatsapp = filter_input(INPUT_POST, 'whatsapp', FILTER_SANITIZE_SPECIAL_CHARS);
    $cpf = filter_input(INPUT_POST, 'cpf', FILTER_SANITIZE_SPECIAL_CHARS);
    $senha = 'tiktok'; 

    if ($email && $nome) {
        try {
            $pdo->beginTransaction();

            // A. Verifica/Cria Usuário
            $stmtUser = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
            $stmtUser->execute([$email]);
            $user = $stmtUser->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                $userId = $user['id'];
                try {
                    $pdo->prepare("UPDATE usuarios SET nome = ?, whatsapp = ?, cpf = ? WHERE id = ?")->execute([$nome, $whatsapp, $cpf, $userId]);
                } catch (Exception $e) { }
            } else {
                $hash = password_hash($senha, PASSWORD_DEFAULT);
                $stmtInsert = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, whatsapp, cpf, tipo) VALUES (?, ?, ?, ?, ?, 'cliente')");
                $stmtInsert->execute([$nome, $email, $hash, $whatsapp, $cpf]);
                $userId = $pdo->lastInsertId();
            }

            // B. Identifica Curso
            $stmtCurso = $pdo->prepare("SELECT id FROM cursos WHERE produto_id = ?");
            $stmtCurso->execute([$id_produto]);
            $cursosVinculados = $stmtCurso->fetchAll(PDO::FETCH_ASSOC);

            if (empty($cursosVinculados)) { $cursosVinculados[] = ['id' => 1]; }

            // C. Matrícula
            foreach ($cursosVinculados as $c) {
                $checkMat = $pdo->prepare("SELECT id FROM matriculas WHERE usuario_id = ? AND curso_id = ?");
                $checkMat->execute([$userId, $c['id']]);
                if (!$checkMat->fetch()) {
                    $pdo->prepare("INSERT INTO matriculas (usuario_id, curso_id, ativo) VALUES (?, ?, 1)")->execute([$userId, $c['id']]);
                }
            }

            // D. Cria Pedido Grátis
            $stmtPed = $pdo->prepare("INSERT INTO pedidos (usuario_id, produto_id, valor_total, status, data_pedido) VALUES (?, ?, 0.00, 'aprovado', NOW())");
            $stmtPed->execute([$userId, $id_produto]);
            $pedidoId = $pdo->lastInsertId();

            // E. Afiliado
            if ($ref) {
                $stmtAfiliado = $pdo->prepare("SELECT id FROM usuarios WHERE codigo_afiliado = ?");
                $stmtAfiliado->execute([$ref]);
                $afiliado = $stmtAfiliado->fetch(PDO::FETCH_ASSOC);
                if ($afiliado) {
                    try {
                        $pdo->prepare("UPDATE usuarios SET total_vendas_afiliado = total_vendas_afiliado + 1 WHERE id = ?")->execute([$afiliado['id']]);
                    } catch (Exception $e) { }
                }
            }

            // F. DISPARA O E-MAIL (COM LOG DE DEBUG)
            if ($email_loaded && function_exists('enviarAcessoAluno')) {
                // Envia e-mail de boas-vindas
                enviarAcessoAluno($email, $nome);
                // Log opcional para debug (pode remover depois)
                file_put_contents('email_debug.txt', date('d/m H:i') . " - Tentativa de envio para $email\n", FILE_APPEND);
            } else {
                file_put_contents('email_debug.txt', date('d/m H:i') . " - ERRO: Função de email não encontrada\n", FILE_APPEND);
            }

            $pdo->commit();

            // === AUTO-LOGIN ===
            $_SESSION['usuario_id'] = $userId;
            $_SESSION['email'] = $email;
            $_SESSION['nome'] = $nome;
            $_SESSION['tipo'] = 'cliente';

            // G. Redireciona
            header("Location: obrigado.php?pedido_id=" . $pedidoId);
            exit;

        } catch (Exception $e) {
            $pdo->rollBack();
            $erro_gratis = "Erro no processamento: " . $e->getMessage();
        }
    } else {
        $erro_gratis = "Preencha todos os campos obrigatórios.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Checkout - <?= htmlspecialchars($produto['nome']) ?></title>
<link rel="icon" href="https://www.tiktok.com/favicon.ico" type="image/x-icon" />
<link rel="shortcut icon" href="https://www.tiktok.com/favicon.ico" type="image/x-icon" />
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>
<script src="https://unpkg.com/imask"></script>

<?php if ($produto['preco_atual'] > 0): ?>
<script src="https://api.nivuspayments.com.br/v1/js"></script>
<script>
  NivusPay.setPublicKey("");
</script>
<?php endif; ?>

<style>
    /* SEU CSS ORIGINAL MANTIDO */
    #additional-info-fields { display: none; opacity: 0; transition: opacity 0.5s; }
    .fade-in { display: block !important; opacity: 1 !important; }
    .btn-outline { background: transparent; border: 1px solid #ccc; color: #666; padding: 10px; width: 100%; border-radius: 5px; cursor: pointer; margin-top: 10px; font-size: 14px; }
    .btn-outline:hover { background: #f9f9f9; color: #333; }
</style>
</head>
<body>

<header class="site-header">
  <div class="header-container">
    <img src="<?= htmlspecialchars($logo_url) ?>" alt="<?= htmlspecialchars($loja['nome_loja'] ?? 'Loja') ?>" class="header-logo" onerror="this.src='https://placehold.co/120x40?text=Logo'">
    <img src="images/100pag.svg" alt="Pagamento 100% Seguro" class="header-secure-logo">
  </div>
</header>

<div class="progress-container">
  <div class="progress-bar">
    <div class="step active" id="p-step-1">1</div>
    <div class="line"></div>
    <div class="step" id="p-step-2">2</div>
    <div class="line"></div>
    <div class="step" id="p-step-3">3</div>
  </div>
</div>

<!-- LÓGICA INTELIGENTE DO FORMULÁRIO -->
<form action="<?= $produto['preco_atual'] <= 0 ? '' : 'process_payment.php' ?>" method="POST" id="checkout-form">
    <input type="hidden" name="product_id" value="<?= $produto['id'] ?>">
    
    <!-- Flag para identificar checkout gratuito no PHP -->
    <?php if($produto['preco_atual'] <= 0): ?>
        <input type="hidden" name="action" value="free_checkout">
    <?php endif; ?>

    <div class="checkout-container">
      
      <div class="form-section cart" id="cart-summary-top">
        <p><b>Seu Carrinho</b></p>
        <div class="cart-item">
          <!-- Ajuste de caminho da imagem se for local -->
          <img src="<?php echo strpos($produto['imagem_principal'], 'http')===0 ? $produto['imagem_principal'] : '../'.$produto['imagem_principal']; ?>" alt="Produto" onerror="this.src='https://placehold.co/80'">
          <div>
            <p><?= htmlspecialchars($produto['nome']) ?></p>
          </div>
        </div>
        <div class="cart-summary-details">
          <div class="summary-line">
            <span>Subtotal</span>
            <span id="cart-summary-subtotal">R$ <?= number_format($produto['preco_atual'], 2, ',', '.') ?></span>
          </div>
          <div class="summary-line">
            <span>Frete</span>
            <span id="cart-summary-shipping">Entrega Digital</span>
          </div>
          <div class="summary-line total">
            <span><b>Total</b></span>
            <strong id="cart-summary-total">R$ <?= number_format($produto['preco_atual'], 2, ',', '.') ?></strong>
          </div>
        </div>
      </div>

      <!-- PASSO 1: MANTIDO ORIGINAL -->
      <div id="step-1" class="step-container active">
        <div class="step-header">
          <span class="step-number">1</span>
          <h2>IDENTIFICAÇÃO</h2>
          <i class="fas fa-check-circle step-completed-icon" style="display: none;"></i>
          <button type="button" class="edit-btn" style="display: none;" onclick="goBackToStep1()"><i class="fas fa-pencil-alt"></i></button>
        </div>
        
        <?php if($erro_gratis): ?>
            <div style="background: #fee2e2; color: #991b1b; padding: 10px; border-radius: 6px; margin-bottom: 15px; font-size: 13px; font-weight: bold;">
                <?= $erro_gratis ?>
            </div>
        <?php endif; ?>

        <div class="step-content">
          <p class="step-description">Utilizaremos seu e-mail para liberar seu acesso imediatamente.</p>
          
          <div class="form-group">
            <label>E-mail:</label>
            <input type="email" id="email" name="email" placeholder="exemplo@email.com" required onkeyup="checkEmailInput()">
            <span id="email-error" class="error-message" style="display: none;">Por favor, insira um e-mail válido.</span>
          </div>
          
          <div id="additional-info-fields">
            <div class="form-group">
                <label>Nome Completo:</label>
                <input type="text" id="full_name" name="nome" placeholder="Seu nome completo" required>
            </div>
            <div class="form-group">
                <label>CPF:</label>
                <input type="text" id="cpf" name="cpf" placeholder="000.000.000-00" required>
            </div>
            <div class="form-group">
                <label>WhatsApp:</label>
                <input type="text" id="whatsapp" name="whatsapp" placeholder="(00) 00000-0000" required>
            </div>

            <button type="button" id="step1-continue-btn" class="continue-btn" onclick="skipAddressToPayment()" style="background-color: #00b341;">
                Ir para o Pagamento <i class="fas fa-arrow-right"></i>
            </button>
            
            <button type="button" class="btn-outline" onclick="goToAddressStep()">
                Preencher Endereço (Opcional)
            </button>
          </div>
        </div>
        <div class="step-summary" style="display: none;">
          <p id="summary-email"></p>
        </div>
      </div>

      <!-- PASSO 2: MANTIDO ORIGINAL -->
      <div id="step-2" class="step-container">
        <div class="step-header">
          <span class="step-number">2</span>
          <h2>ENDEREÇO (Opcional)</h2>
          <i class="fas fa-check-circle step-completed-icon" style="display: none;"></i>
          <button type="button" class="edit-btn" style="display: none;" onclick="goToAddressStep()"><i class="fas fa-pencil-alt"></i></button>
        </div>
        <div class="step-content" style="display: none;">
          <div id="address-fields">
            <div class="form-group"><input type="text" id="cep" name="cep" placeholder="CEP"></div>
            <div class="form-group"><input type="text" id="estado" name="estado" placeholder="Estado"></div>
            <div class="form-group"><input type="text" id="cidade" name="cidade" placeholder="Cidade"></div>
            <div class="form-group"><input type="text" id="rua" name="rua" placeholder="Rua"></div>
            <div class="row">
              <div class="form-group"><input type="text" id="numero" name="numero" placeholder="Número"></div>
              <div class="form-group"><input type="text" id="bairro" name="bairro" placeholder="Bairro"></div>
            </div>
            <div class="form-group">
              <input type="text" id="complemento" name="complemento" placeholder="Complemento (opcional)">
            </div>
          </div>

          <div id="shipping-fields" class="shipping-options-container" style="margin-top: 25px;">
            <h4>Escolha uma forma de entrega:</h4>
            <label class="shipping-option">
              <input type="radio" name="shipping_option" value="0.00" checked>
              <div class="shipping-details">
                <span class="shipping-title">Entrega Digital (E-mail)</span>
                  <div class="shipping-delivery"><span class="shipping-time">Imediato</span></div>
              </div>
              <span class="shipping-price">Grátis</span>
            </label>
          </div>

          <button type="button" id="step2-continue-btn" class="continue-btn" onclick="goToPaymentStep()">Continuar para Pagamento</button>
        </div>
        <div class="step-summary" style="display: none;">
          <p id="summary-address">Endereço não preenchido (Produto Digital)</p>
        </div>
      </div>

      <!-- PASSO 3: ADAPTADO PARA O CONTEXTO GRÁTIS VS PAGO -->
      <div id="step-3" class="step-container">
        <div class="step-header">
          <span class="step-number">3</span>
          <h2>PAGAMENTO</h2>
        </div>
        <div class="step-content" style="display: none;">
          <div class="form-section" style="margin-bottom: 0;">
            
            <?php if ($produto['preco_atual'] > 0): ?>
                <!-- FLUXO NORMAL (PAGO) - MOSTRA OPÇÕES DE PIX/CARTÃO -->
                <h4>Escolha como pagar:</h4>
                <div class="payment-options-container">
                    <label class="payment-option selected" style="display: flex; align-items: center; padding: 15px; border: 2px solid #00b341; background: #f0fdf4; border-radius: 8px; cursor: pointer; margin-bottom: 10px;">
                        <input type="radio" name="payment_method" value="pix" checked>
                        <i class="fas fa-qrcode payment-icon" style="color: #00b341; font-size: 24px; margin-right: 15px;"></i>
                        <div>
                            <span style="display:block; font-weight:bold; color: #1f2937;">Pix (Aprovação Imediata)</span>
                            <span style="font-size: 12px; color: #00b341;">Liberação automática do curso</span>
                        </div>
                    </label>
                    
                    <label class="payment-option" style="display: flex; align-items: center; padding: 15px; border: 1px solid #ddd; border-radius: 8px; cursor: pointer; opacity: 0.7;">
                        <input type="radio" name="payment_method" value="card" disabled>
                        <i class="fas fa-credit-card payment-icon" style="font-size: 24px; margin-right: 15px; color: #666;"></i>
                        <span>Cartão de Crédito (Em breve)</span>
                    </label>
                </div>
            <?php else: ?>
                <!-- FLUXO GRÁTIS - MOSTRA AVISO DE GRATUIDADE -->
                <h4>Confirmação:</h4>
                <div style="padding: 15px; border: 2px solid #00b341; background: #f0fdf4; border-radius: 8px; cursor: pointer; margin-bottom: 10px;">
                    <div style="display: flex; align-items: center;">
                        <i class="fas fa-gift" style="color: #00b341; font-size: 24px; margin-right: 15px;"></i>
                        <div>
                            <span style="display:block; font-weight:bold; color: #1f2937;">Produto 100% Gratuito</span>
                            <span style="font-size: 12px; color: #00b341;">Seu acesso será liberado imediatamente.</span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

          </div>
          
          <div class="summary">
            <p><b>Resumo final</b></p>
            <div class="summary-line total">
              <span><b>Total a pagar</b></span> 
              <strong id="summary-total">R$ <?= number_format($produto['preco_atual'], 2, ',', '.') ?></strong>
            </div>
          </div>
          
          <button type="submit" id="final-submit-btn" class="continue-btn" style="background-color: #00b341; font-size: 18px; padding: 16px;">
             <?php if ($produto['preco_atual'] > 0): ?>
                 <i class="fas fa-lock"></i> FINALIZAR E RECEBER ACESSO
             <?php else: ?>
                 <i class="fas fa-check-circle"></i> CONFIRMAR INSCRIÇÃO GRÁTIS
             <?php endif; ?>
          </button>
          
          <p style="text-align: center; font-size: 12px; color: #999; margin-top: 15px;">
              Ao clicar, você concorda com os Termos de Uso.
          </p>
        </div>
      </div>

    </div>
</form>

<div class="footer-features">
  <div class="feature-box">
    <div class="feature-header">
      <img src="images/reclameaqui.png" alt="Ícone Reclame Aqui" class="feature-icon" onerror="this.style.display='none'">
      <h4>Reclame Aqui</h4>
    </div>
    <div class="stars">★★★★★</div>
    <p><b>15.623 Avaliações positivas</b>. Sua compra está segura.</p>
  </div>

  <div class="feature-box">
    <div class="feature-header">
      <img src="images/correios.png" alt="Ícone Correios" class="feature-icon" onerror="this.style.display='none'">
      <h4>Entrega Imediata</h4>
    </div>
    <div class="stars">★★★★★</div>
    <p>Acesso enviado automaticamente para seu e-mail após a confirmação.</p>
  </div>

  <div class="feature-box">
    <div class="feature-header">
      <img src="images/devolucao.png" alt="Ícone Garantia" class="feature-icon" onerror="this.style.display='none'">
      <h4>Sua Garantia</h4>
    </div>
    <div class="stars">★★★★★</div>
    <p>Garantia incondicional de 7 dias ou seu dinheiro de volta.</p>
  </div>
</div>

<div class="secure-footer">
  <p>Ambiente 100% Seguro</p>
  <div class="secure-footer-images">
    <img src="images/pagseguro.svg" alt="Pagamento Seguro" onerror="this.style.display='none'">
    <img src="images/sslseguro.svg" alt="SSL Seguro" onerror="this.style.display='none'">
  </div>
</div>

<script>
    // Variável PHP para JS
    const productPrice = <?= $produto['preco_atual'] ?>;

    // 1. Mostrar campos quando digitar e-mail
    function checkEmailInput() {
        const email = document.getElementById('email').value;
        const fields = document.getElementById('additional-info-fields');
        // Validação simples: tem @ e .
        if (email.includes('@') && email.includes('.') && email.length > 5) {
            fields.classList.add('fade-in');
            fields.style.display = 'block';
            setTimeout(() => fields.style.opacity = '1', 50);
        }
    }

    // 2. Lógica: Pular Endereço (Ir direto para o Passo 3)
    function skipAddressToPayment() {
        // Validação Básica
        const nome = document.getElementById('full_name').value;
        const cpf = document.getElementById('cpf').value;
        if(nome.length < 3 || cpf.length < 11) {
            alert("Por favor, preencha seu Nome e CPF.");
            return;
        }

        // Fecha Passo 1
        document.getElementById('step-1').classList.remove('active');
        document.querySelector('#step-1 .step-content').style.display = 'none';
        document.querySelector('#step-1 .edit-btn').style.display = 'block';
        document.querySelector('#step-1 .step-completed-icon').style.display = 'inline-block';
        document.getElementById('summary-email').innerText = document.getElementById('email').value;
        document.querySelector('#step-1 .step-summary').style.display = 'block';

        // PULA Passo 2 (Endereço) visualmente
        document.getElementById('p-step-2').classList.add('active'); // Marca bolinha 2
        
        // ABRE Passo 3 (Pagamento)
        document.getElementById('step-3').classList.add('active');
        document.querySelector('#step-3 .step-content').style.display = 'block';
        document.getElementById('p-step-3').classList.add('active'); // Marca bolinha 3
        
        // Rola a tela
        document.getElementById('step-3').scrollIntoView({ behavior: 'smooth' });
    }

    // 3. Lógica: Quero Preencher Endereço (Fluxo Normal)
    function goToAddressStep() {
        // Fecha Passo 1
        document.getElementById('step-1').classList.remove('active');
        document.querySelector('#step-1 .step-content').style.display = 'none';
        document.querySelector('#step-1 .edit-btn').style.display = 'block';
        document.querySelector('#step-1 .step-completed-icon').style.display = 'inline-block';
        document.getElementById('summary-email').innerText = document.getElementById('email').value;
        document.querySelector('#step-1 .step-summary').style.display = 'block';

        // Abre Passo 2
        document.getElementById('step-2').classList.add('active');
        document.querySelector('#step-2 .step-content').style.display = 'block';
        document.getElementById('p-step-2').classList.add('active');
    }

    // 4. Do Endereço para o Pagamento
    function goToPaymentStep() {
        // Fecha Passo 2
        document.getElementById('step-2').classList.remove('active');
        document.querySelector('#step-2 .step-content').style.display = 'none';
        document.querySelector('#step-2 .edit-btn').style.display = 'block';
        document.querySelector('#step-2 .step-completed-icon').style.display = 'inline-block';
        document.getElementById('summary-address').innerText = document.getElementById('rua').value + ', ' + document.getElementById('numero').value;
        document.querySelector('#step-2 .step-summary').style.display = 'block';

        // Abre Passo 3
        document.getElementById('step-3').classList.add('active');
        document.querySelector('#step-3 .step-content').style.display = 'block';
        document.getElementById('p-step-3').classList.add('active');
    }

    // 5. Voltar para editar
    function goBackToStep1() {
        document.querySelector('#step-1 .step-content').style.display = 'block';
        document.querySelector('#step-1 .step-summary').style.display = 'none';
        document.querySelector('#step-2 .step-content').style.display = 'none';
        document.querySelector('#step-3 .step-content').style.display = 'none';
    }

    // Máscaras (Depende da lib imask carregada no head)
    document.addEventListener('DOMContentLoaded', function() {
        if(typeof IMask !== 'undefined') {
            try {
                const cpfEl = document.getElementById('cpf');
                if(cpfEl) IMask(cpfEl, {mask: '000.000.000-00'});
                
                const wppEl = document.getElementById('whatsapp');
                if(wppEl) IMask(wppEl, {mask: '(00) 00000-0000'});
                
                const cepEl = document.getElementById('cep');
                if(cepEl) IMask(cepEl, {mask: '00000-000'});
            } catch(e) {}
        }
    });
</script>

</body>
</html>