<?php
// ==============================================================================
// DISPARADOR DE E-MAIL DE ACESSO (DESIGN PREMIUM)
// ==============================================================================

// 1. Carrega o Motor de Envio (que está na raiz)
if (!function_exists('enviarEmailSMTP')) {
    $paths_engine = ['../enviar_email.php', '../../enviar_email.php', 'enviar_email.php'];
    foreach ($paths_engine as $pe) {
        if (file_exists($pe)) {
            require_once $pe;
            break;
        }
    }
}

// 2. Carrega Configuração do Banco
if (!isset($pdo)) {
    $paths_config = ['../config.php', '../../config.php', 'config.php'];
    foreach ($paths_config as $pc) {
        if (file_exists($pc)) {
            require_once $pc;
            break;
        }
    }
}

function enviarAcessoAluno($usuario_email, $usuario_nome) {
    global $pdo;

    // Se o motor não foi carregado, tenta fallback nativo
    if (!function_exists('enviarEmailSMTP')) {
        $headers = "Content-type: text/html; charset=UTF-8\r\n";
        @mail($usuario_email, "Acesso Liberado", "Olá $usuario_nome, seu acesso foi liberado.", $headers);
        return false;
    }

    // Busca nome da loja para personalizar o cabeçalho
    $nome_loja = "TheLike.PRO"; // Padrão
    if (isset($pdo)) {
        try {
            $stmt = $pdo->query("SELECT nome_loja FROM config_loja WHERE id=1");
            if ($stmt) {
                $dado = $stmt->fetch();
                if ($dado && !empty($dado['nome_loja'])) $nome_loja = $dado['nome_loja'];
            }
        } catch (Exception $e) {}
    }

    $assunto = "🎉 Seu Acesso Chegou: $nome_loja";
    $primeiro_nome = explode(' ', trim($usuario_nome))[0];
    $link_acesso = "https://" . $_SERVER['HTTP_HOST'] . "/area_aluno.php";
    $link_texto = $_SERVER['HTTP_HOST'] . "/area_aluno.php";
    $ano_atual = date('Y');

    // TEMPLATE PREMIUM (O DESIGN QUE VOCÊ ENVIOU)
    $mensagem = "

    <!DOCTYPE html>
    <html lang='pt-br'>
    <head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Seu Acesso Chegou</title>
    <style>
        /* Reset básico para clientes de email */
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f4f4f9; margin: 0; padding: 0; -webkit-font-smoothing: antialiased; }
        
        /* Container Principal (A 'Folha' do e-mail) */
        .email-container { 
            max-width: 600px; 
            margin: 40px auto; 
            background-color: #ffffff; 
            border-radius: 12px; 
            overflow: hidden; 
            box-shadow: 0 10px 25px rgba(0,0,0,0.05); 
            border: 1px solid #eeeeee;
        }

        /* Cabeçalho Escuro */
        .header { 
            background-color: #111111; 
            padding: 35px 20px; 
            text-align: center; 
            border-bottom: 4px solid #ff0050; 
        }
        .header h1 { 
            color: #ffffff; 
            margin: 0; 
            font-size: 18px; 
            letter-spacing: 1px; 
            text-transform: uppercase; 
        }

        /* Conteúdo */
        .content { padding: 25px 25px; color: #333333; line-height: 1.6; }
        
        /* Texto de Boas Vindas */
        .welcome-text { 
            font-size: 15px; 
            font-weight: 800; 
            color: #111; 
            margin-bottom: 18px; 
        }
        
        /* Cartão de Credenciais */
        .card-login { 
            background-color: #f8f9fa; 
            border-left: 5px solid #ff0050; 
            padding: 25px; 
            border-radius: 6px; 
            margin: 30px 0; 
            box-shadow: inset 0 0 10px rgba(0,0,0,0.02);
        }
        
        .label { 
            font-size: 11px; 
            color: #888; 
            text-transform: uppercase; 
            font-weight: 700; 
            letter-spacing: 0.5px; 
            margin-bottom: 4px; 
            display: block; 
        }
        .value { 
            font-size: 14px; 
            color: #000; 
            font-weight: 600; 
            margin-bottom: 12px; 
            display: block; 
            font-family: 'Courier New', monospace; 
        }
        .value:last-child { margin-bottom: 0; }

        /* Botão de Ação (CTA) */
        .btn-acesso { 
            display: block; 
            width: 100%; 
            text-align: center; 
            background-color: #ff0050; 
            color: #ffffff !important; 
            padding: 16px 0; 
            text-decoration: none; 
            border-radius: 8px; 
            font-weight: 800; 
            font-size: 12px; 
            margin-top: 25px; 
            box-shadow: 0 4px 15px rgba(255, 0, 80, 0.3); 
            transition: transform 0.2s;
        }
        .btn-acesso:hover { background-color: #d60043; }

        /* Rodapé */
        .footer { 
            background-color: #f0f0f0; 
            padding: 25px; 
            text-align: center; 
            font-size: 10px; 
            color: #999; 
            border-top: 1px solid #e5e5e5;
        }
    </style>
    </head>
    <body>

        <div class='email-container'>
            <!-- CABEÇALHO -->
            <div class='header'>
                <h1>$nome_loja</h1>
            </div>

            <!-- CORPO DO E-MAIL -->
            <div class='content'>
                <div class='welcome-text'>Parabéns, $primeiro_nome! 🎉</div>
                
                <p>Sua inscrição foi confirmada com sucesso. <br>Que bom ter você aqui!</p>
                
                <p>Seu acesso ao conteúdo exclusivo já está liberado.</p>
                
                <!-- ÁREA DE DADOS -->
                <div class='card-login'>
                    <span class='label'>Link de Acesso</span>
                    <span class='value' style='color: #0066cc; font-size: 10px;'>$link_texto</span>

                    <span class='label'>Seu Login (E-mail)</span>
                    <span class='value'>$usuario_email</span>
                    
                    <span class='label'>Sua Senha Provisória</span>
                    <span class='value' style='color: #ff0050;'>tiktok</span>
                    <small style='color:#999; display:block; margin-top:-10px; font-size: 10px;'>(Ou use sua senha atual se já tiver cadastro)</small>
                </div>

                <p style='font-size: 12px; color: #666;'>Clique no botão abaixo e comece assistir agora:</p>

                <a href='$link_acesso' class='btn-acesso'>ACESSAR PLATAFORMA AGORA</a>
            </div>

            <!-- RODAPÉ -->
            <div class='footer'>
                <p>&copy; $ano_atual $nome_loja. Todos os direitos reservados.</p>
                <p>Precisa de ajuda? Responda este e-mail.</p>
            </div>
        </div>

    </body>
    </html>
    ";

    return enviarEmailSMTP($usuario_email, $assunto, $mensagem);
}
?>
?>