<?php
// === CONEXÃO COM O BANCO ===
// Força o cookie para a raiz para evitar perda de sessão entre pastas
session_set_cookie_params(0, '/'); 
session_start();

$paths = ['../../config.php', '../config.php', 'config.php'];
$config_loaded = false;
foreach ($paths as $path) { 
    if (file_exists($path)) { 
        require_once $path; 
        $config_loaded = true; 
        break; 
    }
}
if (!$config_loaded) { die("Erro de configuração."); }

$pedido_id = $_GET['pedido_id'] ?? 0;

// Busca os dados do usuário com base no pedido
$stmt = $pdo->prepare("
    SELECT u.id, u.nome, u.email 
    FROM pedidos p 
    JOIN usuarios u ON p.usuario_id = u.id 
    WHERE p.id = ?
");
$stmt->execute([$pedido_id]);
$dados = $stmt->fetch();

if (!$dados) {
    die("<div style='text-align:center; padding:50px;'><h1>Pedido não encontrado.</h1><a href='../index.php'>Voltar para loja</a></div>");
}

$primeiro_nome = explode(' ', trim($dados['nome']))[0];

// === AUTO-LOGIN CORRIGIDO ===
// Agora usamos as mesmas variáveis que o seu area_aluno.php espera ('aluno_id')
$_SESSION['aluno_id']   = $dados['id'];
$_SESSION['aluno_nome'] = $dados['nome'];
$_SESSION['email']      = $dados['email']; // Opcional, mas útil
$_SESSION['tipo']       = 'cliente';

// Salva a sessão imediatamente
session_write_close();
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Compra Aprovada!</title>
<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<style>
    body { font-family: 'Inter', sans-serif; background-color: #f0fdf4; }
    .success-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        overflow: hidden;
        border-top: 8px solid #16a34a; /* Verde sucesso */
    }
    .data-box {
        background-color: #f3f4f6;
        border: 1px dashed #d1d5db;
        border-radius: 10px;
        padding: 15px;
    }
</style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">

    <div class="success-card w-full max-w-lg">
        <div class="p-8 text-center">
            
            <div class="mx-auto flex items-center justify-center h-24 w-24 rounded-full bg-green-100 mb-6">
                <svg class="h-12 w-12 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                </svg>
            </div>

            <h1 class="text-3xl font-extrabold text-gray-900 mb-2">Parabéns, <?= $primeiro_nome ?>!</h1>
            <p class="text-gray-500 mb-8">Seu pagamento foi confirmado e seu acesso já foi liberado.</p>

            <div class="text-left mb-8">
                <p class="text-xs font-bold text-gray-500 uppercase tracking-wide mb-2 ml-1">Seus dados de acesso:</p>
                
                <div class="data-box space-y-4">
                    <div class="flex justify-between items-center border-b border-gray-200 pb-3">
                        <span class="text-sm text-gray-500">Acesso:</span>
                        <a href="../area_aluno.php" class="text-blue-600 font-bold hover:underline text-sm truncate">
                            tiktokshop.thelike.pro/area_aluno.php
                        </a>
                    </div>

                    <div class="flex justify-between items-center border-b border-gray-200 pb-3">
                        <span class="text-sm text-gray-500">E-mail (Login):</span>
                        <span class="font-bold text-gray-800 text-sm"><?= $dados['email'] ?></span>
                    </div>

                    <div class="flex justify-between items-center">
                        <span class="text-sm text-gray-500">Senha Padrão:</span>
                        <div class="flex items-center gap-2">
                            <span class="bg-green-100 text-green-800 font-extrabold px-3 py-1 rounded text-lg tracking-wider border border-green-200">
                                tiktok
                            </span>
                        </div>
                    </div>
                </div>
                
                <p class="text-xs text-gray-400 mt-2 text-center">
                    <i class="fas fa-info-circle"></i> Você pode alterar essa senha depois no seu perfil.
                </p>
            </div>

            <!-- BOTÃO MÁGICO (AUTO-LOGIN VIA POST) -->
            <!-- Envia os dados para o area_aluno.php processar caso a sessão falhe -->
            <form action="../area_aluno.php" method="POST">
                <input type="hidden" name="acao" value="entrar"> <!-- Campo necessário para ativar o login no area_aluno.php -->
                <input type="hidden" name="email" value="<?= htmlspecialchars($dados['email']) ?>">
                <input type="hidden" name="senha" value="tiktok">
                
                <button type="submit" class="w-full flex items-center justify-center gap-2 bg-[#ff0050] hover:bg-[#d60043] text-white font-bold py-4 px-6 rounded-xl transition duration-300 shadow-lg shadow-pink-500/30 transform hover:-translate-y-1 cursor-pointer border-0">
                    <i class="fas fa-play-circle"></i> ACESSAR ÁREA DE MEMBROS AGORA
                </button>
            </form>

        </div>
        
        <div class="bg-gray-50 px-8 py-4 text-center">
            <p class="text-xs text-gray-400">Enviamos também um e-mail com esses dados.</p>
        </div>
    </div>

</body>
</html>