<?php
// ==============================================================================
// 1. CONEXÃO E DADOS
// ==============================================================================
$paths = ['../../config.php', '../config.php', 'config.php'];
$config_loaded = false;
foreach ($paths as $path) { 
    if (file_exists($path)) { 
        require_once $path; 
        $config_loaded = true; 
        break; 
    }
}
if (!$config_loaded) { die("Erro: config.php não encontrado."); }

$pedido_id = $_GET['pedido_id'] ?? 0;

// Busca dados do Pedido e do Produto
$stmt = $pdo->prepare("
    SELECT p.*, prod.nome as produto_nome 
    FROM pedidos p 
    JOIN produtos prod ON p.produto_id = prod.id 
    WHERE p.id = ?
");
$stmt->execute([$pedido_id]);
$pedido = $stmt->fetch();

// Busca dados da Loja para o Header
$stmt_loja = $pdo->prepare("SELECT * FROM config_loja WHERE id = 1");
$stmt_loja->execute();
$loja = $stmt_loja->fetch();
$logo_url = 'images/logo.jpg';

if (!$pedido) { die("Pedido não encontrado."); }

// Se já estiver pago, manda para obrigado
if ($pedido['status'] == 'aprovado') {
    header("Location: obrigado.php?pedido_id=" . $pedido_id);
    exit;
}

// Verifica se a API mandou imagem Base64 ou se vamos gerar via JS
$tem_imagem_base64 = (!empty($pedido['qr_code_img']) && strpos($pedido['qr_code_img'], 'base64') !== false);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Pagamento Pix - <?= htmlspecialchars($pedido['produto_nome']) ?></title>
<link rel="icon" href="https://www.tiktok.com/favicon.ico" type="image/x-icon" />
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>

<style>
    body { background-color: #f3f4f6; }
    
    /* Container Centralizado */
    .pix-wrapper {
        max-width: 450px;
        margin: 40px auto;
        background: #fff;
        border-radius: 16px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        overflow: hidden;
        font-family: 'Inter', sans-serif;
    }

    /* Cabeçalho do Valor */
    .pix-amount-header {
        background: #111827;
        color: #fff;
        padding: 25px;
        text-align: center;
    }
    .pix-amount-header p { margin: 0; font-size: 13px; opacity: 0.8; text-transform: uppercase; letter-spacing: 1px; }
    .pix-amount-header h2 { margin: 5px 0 0; font-size: 32px; font-weight: 700; color: #fff; }

    /* Corpo */
    .pix-content { padding: 30px; text-align: center; }
    
    /* Caixa do QR Code (IMPORTANTE PARA NÃO SUMIR) */
    .qr-frame {
        width: 240px;
        height: 240px;
        margin: 20px auto;
        border: 2px dashed #e5e7eb;
        border-radius: 12px;
        padding: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #fff;
    }
    /* Força a imagem gerada pelo JS a preencher o espaço */
    .qr-frame img, .qr-frame canvas {
        width: 100% !important;
        height: auto !important;
        display: block;
    }

    /* Input Copia e Cola */
    .copy-box {
        display: flex;
        background: #f9fafb;
        border: 1px solid #d1d5db;
        border-radius: 8px;
        padding: 0;
        margin-top: 20px;
        overflow: hidden;
    }
    .copy-input {
        flex: 1;
        border: none;
        background: transparent;
        padding: 12px;
        font-size: 12px;
        color: #6b7280;
        font-family: monospace;
        outline: none;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .copy-btn {
        background: #00b341;
        color: white;
        border: none;
        padding: 0 20px;
        font-weight: 600;
        font-size: 13px;
        cursor: pointer;
        transition: background 0.2s;
    }
    .copy-btn:hover { background: #009636; }

    /* Loader */
    .status-check {
        margin-top: 25px;
        font-size: 13px;
        color: #6b7280;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        animation: pulse 2s infinite;
    }
    @keyframes pulse { 0% { opacity: 0.6; } 50% { opacity: 1; } 100% { opacity: 0.6; } }
</style>
</head>
<body>

<header class="site-header">
  <div class="header-container">
    <img src="<?= htmlspecialchars($logo_url) ?>" alt="<?= htmlspecialchars($loja['nome_loja'] ?? 'Loja') ?>" class="header-logo" onerror="this.src='https://placehold.co/120x40?text=Logo'">
    <img src="images/100pag.svg" alt="Pagamento 100% Seguro" class="header-secure-logo">
  </div>
</header>

<div class="pix-wrapper">
    <div class="pix-amount-header">
        <p>Total a Pagar</p>
        <h2>R$ <?= number_format($pedido['valor_total'], 2, ',', '.') ?></h2>
    </div>

    <div class="pix-content">
        <h3 style="color: #1f2937; font-size: 18px; margin-bottom: 8px;">Pagamento via Pix</h3>
        <p style="color: #6b7280; font-size: 14px; margin: 0;">Abra o app do seu banco e escaneie o código.</p>

        <div class="qr-frame" id="qrcode_container">
            <?php if ($tem_imagem_base64): ?>
                <img src="data:image/png;base64,<?= $pedido['qr_code_img'] ?>" alt="QR Code Pix">
            <?php else: ?>
                <div id="qrcode_canvas"></div>
            <?php endif; ?>
        </div>

        <div style="text-align: left;">
            <p style="font-size: 11px; font-weight: bold; color: #374151; text-transform: uppercase; margin-bottom: 5px;">Pix Copia e Cola</p>
            <div class="copy-box">
                <input type="text" value="<?= htmlspecialchars($pedido['pix_copia_cola']) ?>" id="pixCode" class="copy-input" readonly>
                <button onclick="copyPix()" class="copy-btn">COPIAR</button>
            </div>
        </div>

        <div class="status-check">
            <i class="fas fa-circle-notch fa-spin"></i>
            Aguardando confirmação do pagamento...
        </div>
        
        <div style="margin-top: 20px; border-top: 1px solid #eee; padding-top: 15px;">
            <a href="obrigado.php?pedido_id=<?= $pedido_id ?>" style="font-size: 12px; color: #999; text-decoration: underline;">
                Já realizei o pagamento
            </a>
        </div>
    </div>
</div>

<div class="secure-footer">
  <p>Ambiente 100% Seguro</p>
  <div class="secure-footer-images">
    <img src="images/pagseguro.svg" alt="Pagamento Seguro">
    <img src="images/sslseguro.svg" alt="SSL Seguro">
  </div>
</div>

<script>
    // === LÓGICA DE GERAÇÃO DO QR CODE ===
    <?php if (!$tem_imagem_base64): ?>
    document.addEventListener("DOMContentLoaded", function() {
        // setTimeout dá tempo do navegador renderizar a div antes de desenhar o QR
        setTimeout(function() {
            var qrText = "<?= $pedido['pix_copia_cola'] ?>";
            
            // Limpa qualquer coisa que possa estar lá
            document.getElementById("qrcode_canvas").innerHTML = "";
            
            // Gera o QR Code
            new QRCode(document.getElementById("qrcode_canvas"), {
                text: qrText,
                width: 220,
                height: 220,
                colorDark : "#000000",
                colorLight : "#ffffff",
                correctLevel : QRCode.CorrectLevel.L
            });
        }, 300); // 300ms de delay de segurança
    });
    <?php endif; ?>

    // === FUNÇÃO DE COPIAR ===
    function copyPix() {
        var copyText = document.getElementById("pixCode");
        
        // Seleciona o texto (mobile friendly)
        copyText.select();
        copyText.setSelectionRange(0, 99999); 

        // Copia para área de transferência
        navigator.clipboard.writeText(copyText.value).then(function() {
            // Feedback visual
            var btn = document.querySelector('.copy-btn');
            var originalText = btn.innerText;
            btn.innerText = "COPIADO!";
            btn.style.background = "#111827";
            setTimeout(function(){
                btn.innerText = originalText;
                btn.style.background = "#00b341";
            }, 2000);
        }, function(err) {
            alert("Não foi possível copiar automaticamente. Selecione e copie manualmente.");
        });
    }

    // === VERIFICAÇÃO AUTOMÁTICA DE STATUS ===
    setInterval(function() {
        fetch('check_status.php?pedido_id=<?= $pedido_id ?>')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'aprovado') {
                window.location.href = 'obrigado.php?pedido_id=<?= $pedido_id ?>';
            }
        })
        .catch(err => console.log('Aguardando pagamento...'));
    }, 3000);
</script>

</body>
</html>