<?php
// ==============================================================================
// WEBHOOK DE PAGAMENTO + SISTEMA DE AFILIADOS (V2.0 - CORRIGIDO)
// ==============================================================================

// Define o fuso horário para o Brasil
date_default_timezone_set('America/Sao_Paulo');

// --- 1. CONFIGURAÇÕES ---

$logFile = 'webhook.log';

function gravarLog($mensagem) {
    global $logFile;
    $dataHora = date('d/m/Y H:i:s');
    file_put_contents($logFile, "$dataHora - $mensagem" . PHP_EOL, FILE_APPEND);
}

// Conexão Segura
$paths = ['config.php', '../config.php'];
foreach ($paths as $p) { if(file_exists($p)) { require_once $p; break; } }

// Importação do Enviador de E-mail
if (file_exists('checkout/enviar_email_acesso.php')) {
    require_once 'checkout/enviar_email_acesso.php';
} elseif (file_exists('enviar_email_acesso.php')) {
    require_once 'enviar_email_acesso.php';
}

// --- 2. RECEBIMENTO DOS DADOS ---

$json = file_get_contents('php://input');
$dados = json_decode($json, true);

if (!$dados) {
    http_response_code(400);
    die('Nenhum dado recebido.');
}

// --- 3. TRATAMENTO INTELIGENTE DE METADATA (WITETEC) ---
// Isso corrige o erro onde o ID do pedido não é encontrado
$metadata = $dados['metadata'] ?? [];
if (is_string($metadata)) {
    $metadata = json_decode($metadata, true); // Decodifica se vier como string
}

// Tenta pegar o ID do Pedido (criado no checkout)
$pedido_id_interno = null;
if (isset($metadata['sellerExternalRef'])) {
    $pedido_id_interno = (int)$metadata['sellerExternalRef'];
} elseif (isset($metadata['pedido_id_interno'])) {
    $pedido_id_interno = (int)$metadata['pedido_id_interno'];
}

// --- 4. IDENTIFICAÇÃO DO PRODUTO (FALLBACK) ---
$idProdutoPlataforma = null;
if (isset($dados['items']) && !empty($dados['items'])) {
    $idProdutoPlataforma = $dados['items'][0]['id']; 
} elseif (isset($dados['Product']['id'])) {
    $idProdutoPlataforma = $dados['Product']['id'];
}

// Status e Transação
$statusBruto = $dados['order_status'] ?? ($dados['status'] ?? '');
$eventType = strtoupper($dados['eventType'] ?? '');
$status = strtoupper($statusBruto);
$transacaoId = $dados['order_id'] ?? ($dados['id'] ?? uniqid());
$valorVenda = isset($dados['amount']) ? ($dados['amount'] / 100) : 0; // TheLikePay manda em centavos geralmente

// Verifica se é pagamento aprovado (Aceita vários formatos)
$isPaid = (in_array($status, ['PAID', 'APPROVED', 'APROVADO', 'COMPLETED']) || $eventType == 'TRANSACTION_PAID');


// --- 5. PROCESSAMENTO DO PAGAMENTO ---

if ($isPaid) {
    
    gravarLog("=== PAGAMENTO CONFIRMADO (Transação: $transacaoId) ===");

    try {
        if(!isset($pdo)) {
            // Fallback conexão manual se o config falhar
            $host = 'localhost'; $db = 'pataibac_TikTokShop'; $user = 'pataibac_Leone'; $pass = 's_!0crm}%uR%'; 
            $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
        }
        
        $pdo->beginTransaction();

        // A. ATUALIZA O PEDIDO (CRUCIAL PARA O PAINEL)
        $idAluno = 0;
        $idCursoInterno = 1; // Padrão

        if ($pedido_id_interno) {
            $stmtPed = $pdo->prepare("SELECT * FROM pedidos WHERE id = ?");
            $stmtPed->execute([$pedido_id_interno]);
            $pedido = $stmtPed->fetch(PDO::FETCH_ASSOC);

            if ($pedido) {
                // Atualiza status para aprovado
                $pdo->prepare("UPDATE pedidos SET status = 'aprovado', data_pagamento = NOW() WHERE id = ?")->execute([$pedido_id_interno]);
                gravarLog("Pedido #$pedido_id_interno atualizado para APROVADO.");
                
                $idAluno = $pedido['usuario_id'];
                
                // Busca o curso vinculado ao produto do pedido
                $stmtC = $pdo->prepare("SELECT id FROM cursos WHERE produto_id = ?");
                $stmtC->execute([$pedido['produto_id']]);
                $curso = $stmtC->fetch();
                if($curso) $idCursoInterno = $curso['id'];
            }
        }

        // Se não achou pedido pelo ID (fallback), tenta pelo e-mail
        if (!$idAluno) {
             $emailAluno = $dados['customer']['email'] ?? ($dados['email'] ?? '');
             if($emailAluno) {
                 $stmtU = $pdo->prepare("SELECT id FROM usuarios WHERE email = ?");
                 $stmtU->execute([$emailAluno]);
                 $u = $stmtU->fetch();
                 if($u) $idAluno = $u['id'];
             }
        }

        // B. MATRÍCULA (LIBERA O ACESSO)
        if ($idAluno) {
            // Verifica se já tem matrícula
            $stmtMat = $pdo->prepare("SELECT id FROM matriculas WHERE usuario_id = ? AND curso_id = ? LIMIT 1");
            $stmtMat->execute([$idAluno, $idCursoInterno]);
            
            if (!$stmtMat->fetch()) {
                $pdo->prepare("INSERT INTO matriculas (usuario_id, curso_id, status, ativo, data_matricula) VALUES (?, ?, 'ativo', 1, NOW())")->execute([$idAluno, $idCursoInterno]);
                gravarLog("Aluno $idAluno matriculado no curso $idCursoInterno.");
            }

            // Envio de E-mail
            $stmtUser = $pdo->prepare("SELECT nome, email FROM usuarios WHERE id = ?");
            $stmtUser->execute([$idAluno]);
            $dadosAluno = $stmtUser->fetch();

            if ($dadosAluno && function_exists('enviarAcessoAluno')) {
                enviarAcessoAluno($dadosAluno['email'], $dadosAluno['nome']);
            }
        }

        // ==============================================================================
        // C. SISTEMA DE AFILIADOS (MANTIDO O SEU CÓDIGO)
        // ==============================================================================
        
        $codigoAfiliado = null;
        
        // Tenta achar código na metadata
        if (isset($metadata['ref'])) {
            $codigoAfiliado = $metadata['ref'];
        } elseif (isset($metadata['affiliate_code'])) {
            $codigoAfiliado = $metadata['affiliate_code'];
        }

        if ($codigoAfiliado && $idAluno) {
            gravarLog("AFILIADOS: Processando comissão para REF: $codigoAfiliado");

            // Busca o afiliado
            $stmtAfiliado = $pdo->prepare("SELECT * FROM usuarios WHERE codigo_afiliado = ? LIMIT 1");
            $stmtAfiliado->execute([$codigoAfiliado]);
            $afiliado = $stmtAfiliado->fetch(PDO::FETCH_ASSOC);

            if ($afiliado) {
                if ($afiliado['id'] == $idAluno) {
                    gravarLog("AFILIADOS: Venda ignorada (Auto-afiliação).");
                } else {
                    // Calcula Comissão
                    $stmtNivel = $pdo->prepare("SELECT comissao_extra FROM afiliados_niveis WHERE id = ?");
                    $stmtNivel->execute([$afiliado['nivel_id'] ?? 1]);
                    $nivel = $stmtNivel->fetch(PDO::FETCH_ASSOC);
                    $bonusNivel = $nivel['comissao_extra'] ?? 0;

                    $porcentagemBase = 30; 
                    $porcentagemTotal = $porcentagemBase + $bonusNivel;
                    
                    // Se o valor veio 0 ou em centavos, ajusta
                    if ($valorVenda > 1000) $valorVenda = $valorVenda / 100; 
                    
                    $valorComissao = ($valorVenda * $porcentagemTotal) / 100;

                    // Credita
                    $sqlUpdateAfiliado = "UPDATE usuarios SET saldo_afiliado = saldo_afiliado + ?, total_vendas_afiliado = total_vendas_afiliado + 1 WHERE id = ?";
                    $pdo->prepare($sqlUpdateAfiliado)->execute([$valorComissao, $afiliado['id']]);

                    // Extrato
                    $descExtrato = "Comissão Venda (Curso ID: $idCursoInterno)";
                    $sqlExtrato = "INSERT INTO afiliados_extrato (usuario_id, tipo, descricao, valor, data_registro) VALUES (?, 'comissao', ?, ?, NOW())";
                    $pdo->prepare($sqlExtrato)->execute([$afiliado['id'], $descExtrato, $valorComissao]);

                    gravarLog("AFILIADOS: R$ $valorComissao creditado para {$afiliado['nome']}.");

                    // Upar de Nível
                    $novasVendas = $afiliado['total_vendas_afiliado'] + 1;
                    $stmtNextLevel = $pdo->prepare("SELECT id FROM afiliados_niveis WHERE vendas_necessarias <= ? ORDER BY id DESC LIMIT 1");
                    $stmtNextLevel->execute([$novasVendas]);
                    $novoNivel = $stmtNextLevel->fetch(PDO::FETCH_ASSOC);

                    if ($novoNivel && $novoNivel['id'] > $afiliado['nivel_id']) {
                        $pdo->prepare("UPDATE usuarios SET nivel_id = ? WHERE id = ?")->execute([$novoNivel['id'], $afiliado['id']]);
                    }
                }
            }
        }

        $pdo->commit();
        http_response_code(200);

    } catch (Exception $e) {
        $pdo->rollBack();
        gravarLog("ERRO: " . $e->getMessage());
        http_response_code(500);
    }
} else {
    http_response_code(200); // Responde OK para a plataforma não ficar reenviando se for status pendente
}
?>