<?php
// ==============================================================================
// MOTOR DE ENVIO DE E-MAIL (COM DEBUG EM ARQUIVO DE TEXTO)
// Salve na raiz: /enviar_email.php
// ==============================================================================

function gravarLogEmail($msg) {
    $arquivo = __DIR__ . '/debug_email.txt';
    $texto = date('d/m/Y H:i:s') . " - " . $msg . PHP_EOL;
    file_put_contents($arquivo, $texto, FILE_APPEND);
}

function enviarEmailSMTP($para, $assunto, $mensagem_html) {
    global $pdo;
    gravarLogEmail("Iniciando envio para: $para | Assunto: $assunto");

    // 1. Tenta conectar ao banco se necessário
    if (!isset($pdo) || !$pdo) {
        $paths = [__DIR__.'/config.php', dirname(__DIR__).'/config.php'];
        foreach($paths as $p) { if(file_exists($p)) { include $p; break; } }
    }

    // 2. Busca Configurações
    $smtp_conf = null;
    $nome_loja = "TikTokShop";
    $email_remetente = "no-reply@" . $_SERVER['HTTP_HOST']; // Padrão seguro

    if (isset($pdo)) {
        try {
            $stmt = $pdo->query("SELECT * FROM config_smtp WHERE id=1");
            if($stmt) $smtp_conf = $stmt->fetch(PDO::FETCH_ASSOC);
            
            $stmt_loja = $pdo->query("SELECT * FROM config_loja WHERE id=1");
            if($stmt_loja) {
                $dado_loja = $stmt_loja->fetch(PDO::FETCH_ASSOC);
                if($dado_loja) $nome_loja = $dado_loja['nome_loja'];
            }
        } catch (Exception $e) {
            gravarLogEmail("Erro ao buscar configs no banco: " . $e->getMessage());
        }
    }

    // 3. TENTATIVA: PHPMailer (Se configurado)
    $usou_phpmailer = false;
    
    if ($smtp_conf && !empty($smtp_conf['host']) && file_exists(__DIR__ . '/PHPMailer/src/PHPMailer.php')) {
        try {
            gravarLogEmail("Tentando via PHPMailer (SMTP)...");
            require_once __DIR__ . '/PHPMailer/src/Exception.php';
            require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
            require_once __DIR__ . '/PHPMailer/src/SMTP.php';

            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $mail->isSMTP();
            $mail->Host       = $smtp_conf['host'];
            $mail->SMTPAuth   = true;
            $mail->Username   = $smtp_conf['email'];
            $mail->Password   = $smtp_conf['senha'];
            $mail->Port       = $smtp_conf['porta'];
            $mail->CharSet    = 'UTF-8';
            $mail->SMTPSecure = ($smtp_conf['porta'] == 465) ? 'ssl' : 'tls';

            $mail->setFrom($smtp_conf['email'], $nome_loja);
            $mail->addAddress($para);
            $mail->isHTML(true);
            $mail->Subject = $assunto;
            $mail->Body    = $mensagem_html;
            $mail->AltBody = strip_tags($mensagem_html);

            $mail->send();
            $usou_phpmailer = true;
            gravarLogEmail("SUCESSO: Enviado via PHPMailer.");
            
        } catch (Exception $e) {
            gravarLogEmail("FALHA PHPMailer: " . $mail->ErrorInfo . " | " . $e->getMessage());
        }
    } else {
        gravarLogEmail("Pulo PHPMailer: Configurações SMTP vazias ou pasta não encontrada.");
    }

    // 4. PLANO B: Envio Nativo (Se o PHPMailer não foi usado)
    if (!$usou_phpmailer) {
        gravarLogEmail("Tentando via mail() nativo...");
        
        $headers  = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8" . "\r\n";
        $headers .= "From: $nome_loja <$email_remetente>" . "\r\n";
        $headers .= "Reply-To: $email_remetente" . "\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion();
        
        $enviado = @mail($para, $assunto, $mensagem_html, $headers);
        
        if ($enviado) {
            gravarLogEmail("SUCESSO: Enviado via mail() nativo.");
            return true;
        } else {
            gravarLogEmail("ERRO CRÍTICO: mail() nativo falhou. Verifique logs do servidor.");
            return false;
        }
    }

    return true;
}
?>