<?php
// ==============================================================================
// 1. CONEXÃO
// ==============================================================================
$paths = ['config.php', 'tiktok/config.php'];
$config_loaded = false;
foreach ($paths as $path) { if (file_exists($path)) { require_once $path; $config_loaded = true; break; }}
if (!$config_loaded) { die("Erro: config.php não encontrado."); }

// Busca configurações da loja
$loja = $pdo->query("SELECT * FROM config_loja WHERE id=1")->fetch();
$nome_loja = $loja['nome_loja'] ?? 'TheLike Academy';
$cor_princ = $loja['cor_primaria'] ?? '#ff0050';

// Busca o produto principal (O primeiro ativo)
// Se quiser um especifico, mude para WHERE id = 1
$stmt = $pdo->query("SELECT * FROM produtos WHERE ativo = 1 ORDER BY id ASC LIMIT 1");
$produto = $stmt->fetch();

// Se não tiver produto, mostra mensagem
if (!$produto) { die("<div style='color:white; background:black; height:100vh; display:flex; align-items:center; justify-content:center;'>Em manutenção.</div>"); }
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($nome_loja) ?> - <?= htmlspecialchars($produto['nome']) ?></title>
    <link rel="icon" href="https://www.tiktok.com/favicon.ico" type="image/x-icon" />
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700;900&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #000; color: #fff; scroll-behavior: smooth; }
        .text-brand { color: <?= $cor_princ ?>; }
        .bg-brand { background-color: <?= $cor_princ ?>; }
        .bg-brand:hover { filter: brightness(110%); }
        .border-brand { border-color: <?= $cor_princ ?>; }
        
        .hero-bg {
            background: radial-gradient(circle at center, #1a1a1a 0%, #000000 100%);
            background-image: url('https://assets.nflxext.com/ffe/siteui/vlv3/f841d4c7-10e1-40af-bcae-07a3f8dc141a/f6d7434e-d6de-4185-a6d4-c77a2d08737b/BR-pt-20220502-popsignuptwoweeks-perspective_alpha_website_medium.jpg');
            background-size: cover;
            background-blend-mode: overlay;
        }
        
        .glow { box-shadow: 0 0 20px <?= $cor_princ ?>40; }
    </style>
</head>
<body>

    <nav class="fixed w-full z-50 bg-black/90 backdrop-blur-sm border-b border-white/10">
        <div class="max-w-6xl mx-auto px-6 h-20 flex justify-between items-center">
            <div class="text-2xl font-black tracking-tighter">
                THE<span class="text-brand">LIKE</span>
            </div>
            
            <div class="flex items-center gap-6">
                <a href="area_aluno.php" class="text-sm font-bold text-gray-300 hover:text-white transition flex items-center gap-2">
                    <i data-lucide="user"></i> Área do Aluno
                </a>
                <a href="#comprar" class="bg-brand text-white px45 py-1 rounded-full font-bold text-sm hover:scale-105 transition shadow-lg shadow-red-900/50">
                    QUERO COMEÇAR
                </a>
            </div>
        </div>
    </nav>

    <header class="hero-bg min-h-screen flex items-center pt-20">
        <div class="max-w-6xl mx-auto px-6 grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
            
            <div class="space-y-6">
                <span class="inline-block bg-white/10 border border-white/20 text-brand px-4 py-1 rounded-full text-xs font-bold tracking-widest uppercase mb-2">
                    Novo Método Exclusivo
                </span>
                <h1 class="text-5xl md:text-7xl font-black leading-tight">
                    Domine o <span class="text-brand">TikTok</span> e monetize seu perfil.
                </h1>
                <p class="text-gray-400 text-lg md:text-xl max-w-lg leading-relaxed">
                    <?= nl2br($produto['descricao'] ?? 'Aprenda as estratégias secretas para crescer, viralizar e transformar visualizações em dinheiro de verdade.') ?>
                </p>
                
                <div class="flex flex-col sm:flex-row gap-4 pt-4">
                    <a href="checkout/?product_id=<?= $produto['id'] ?>" class="bg-brand text-white text-center px-8 py-4 rounded-xl font-bold text-lg hover:scale-105 transition glow flex items-center justify-center gap-2">
                        COMPRAR AGORA <i data-lucide="arrow-right"></i>
                    </a>
                    <a href="#detalhes" class="bg-white/5 border border-white/10 text-white text-center px-8 py-4 rounded-xl font-bold text-lg hover:bg-white/10 transition">
                        Saiba Mais
                    </a>
                </div>
                
                <div class="flex items-center gap-4 text-sm text-gray-500 pt-4">
                    <div class="flex items-center gap-1"><i data-lucide="shield-check" class="w-4 h-4 text-green-500"></i> Pagamento Seguro</div>
                    <div class="flex items-center gap-1"><i data-lucide="zap" class="w-4 h-4 text-yellow-500"></i> Acesso Imediato</div>
                </div>
            </div>

            <div class="relative group">
                <div class="absolute -inset-1 bg-gradient-to-r from-red-600 to-pink-600 rounded-2xl blur opacity-25 group-hover:opacity-50 transition duration-1000 group-hover:duration-200"></div>
                <div class="relative bg-[#111] border border-white/10 rounded-2xl overflow-hidden shadow-2xl">
                    <?php if(!empty($produto['imagem_principal'])): ?>
                        <img src="<?= $produto['imagem_principal'] ?>" class="w-full h-auto object-cover transform transition duration-500 hover:scale-105">
                    <?php else: ?>
                        <div class="aspect-[4/5] bg-[#222] flex items-center justify-center flex-col text-gray-700">
                            <i data-lucide="image" class="w-24 h-24 mb-4"></i>
                            <span class="font-bold">Imagem do Produto</span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="absolute bottom-6 right-6 bg-white text-black px-6 py-3 rounded-lg font-black text-xl shadow-xl transform rotate-3">
                        <span class="text-xs font-medium text-gray-500 block">POR APENAS</span>
                        R$ <?= number_format($produto['preco_atual'], 2, ',', '.') ?>
                    </div>
                </div>
            </div>

        </div>
    </header>

    <section id="detalhes" class="py-24 bg-[#0a0a0a] border-t border-white/5">
        <div class="max-w-6xl mx-auto px-6">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold mb-4">O que você vai <span class="text-brand">receber</span></h2>
                <p class="text-gray-400">Tudo o que você precisa para sair do zero ao avançado.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="bg-[#111] p-8 rounded-2xl border border-white/5 hover:border-brand/50 transition duration-300">
                    <div class="w-14 h-14 bg-brand/10 rounded-xl flex items-center justify-center mb-6 text-brand">
                        <i data-lucide="play-circle" class="w-8 h-8"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Aulas Práticas</h3>
                    <p class="text-gray-400 leading-relaxed">Conteúdo direto ao ponto, sem enrolação. Assista onde e quando quiser.</p>
                </div>

                <div class="bg-[#111] p-8 rounded-2xl border border-white/5 hover:border-brand/50 transition duration-300">
                    <div class="w-14 h-14 bg-brand/10 rounded-xl flex items-center justify-center mb-6 text-brand">
                        <i data-lucide="smartphone" class="w-8 h-8"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">100% Online</h3>
                    <p class="text-gray-400 leading-relaxed">Acesse pelo celular, tablet ou computador. Plataforma estilo Netflix.</p>
                </div>

                <div class="bg-[#111] p-8 rounded-2xl border border-white/5 hover:border-brand/50 transition duration-300">
                    <div class="w-14 h-14 bg-brand/10 rounded-xl flex items-center justify-center mb-6 text-brand">
                        <i data-lucide="download" class="w-8 h-8"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-3">Materiais de Apoio</h3>
                    <p class="text-gray-400 leading-relaxed">Baixe arquivos, PDFs e ferramentas exclusivas para acelerar seus resultados.</p>
                </div>
            </div>
        </div>
    </section>

    <section id="comprar" class="py-20 bg-gradient-to-b from-brand/20 to-black text-center px-6">
        <div class="max-w-3xl mx-auto">
            <h2 class="text-4xl font-black mb-6">Pronto para começar?</h2>
            <p class="text-xl text-gray-300 mb-8">Junte-se a centenas de alunos e comece sua jornada hoje mesmo com acesso imediato.</p>
            
            <div class="bg-[#111] p-8 rounded-2xl border border-white/10 inline-block w-full max-w-md mx-auto mb-8 relative overflow-hidden">
                <div class="absolute top-0 left-0 w-full h-1 bg-brand"></div>
                <p class="text-gray-400 text-sm uppercase tracking-wide mb-2">OFERTA ESPECIAL</p>
                <div class="flex items-center justify-center gap-3 mb-6">
                    <span class="text-2xl text-gray-500 line-through">R$ <?= number_format($produto['preco_original'], 2, ',', '.') ?></span>
                    <span class="text-4xl font-black text-white">R$ <?= number_format($produto['preco_atual'], 2, ',', '.') ?></span>
                </div>
                <a href="checkout/?product_id=<?= $produto['id'] ?>" class="block w-full bg-brand hover:bg-red-600 text-white font-bold py-4 rounded-xl text-xl transition glow">
                    GARANTIR MINHA VAGA
                </a>
                <p class="text-xs text-gray-500 mt-4 flex items-center justify-center gap-1">
                    <i data-lucide="lock" class="w-3 h-3"></i> Compra 100% Segura
                </p>
            </div>
        </div>
    </section>

    <footer class="py-10 border-t border-white/10 text-center text-gray-500 text-sm">
        <p>&copy; <?= date('Y') ?> <?= htmlspecialchars($nome_loja) ?>. Todos os direitos reservados.</p>
        <div class="flex justify-center gap-4 mt-4">
            <a href="area_aluno.php" class="hover:text-white transition">Área do Aluno</a>
            <a href="#" class="hover:text-white transition">Termos de Uso</a>
            <a href="#" class="hover:text-white transition">Política de Privacidade</a>
        </div>
    </footer>

    <script>
        lucide.createIcons();
    </script>
</body>
</html>