<?php
session_start();
// 1. CONEXÃO
$paths = ['config.php', 'tiktok/config.php']; foreach ($paths as $path) { if (file_exists($path)) { require_once $path; break; }}

// INCLUI O MOTOR DE EMAIL
if (file_exists('enviar_email.php')) {
    require_once 'enviar_email.php';
} else {
    die("Erro: Arquivo enviar_email.php não encontrado.");
}

$msg = '';
$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
    
    // Verifica se o aluno existe
    $stmt = $pdo->prepare("SELECT id, nome FROM usuarios WHERE email = ? AND tipo = 'cliente'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user) {
        // Gera Token
        $token = bin2hex(random_bytes(32));
        $validade = date('Y-m-d H:i:s', strtotime('+1 hour'));

        // Salva no banco
        $pdo->prepare("UPDATE usuarios SET token_recuperacao = ?, token_validade = ? WHERE id = ?")
            ->execute([$token, $validade, $user['id']]);

        // Link
        $link = "https://" . $_SERVER['HTTP_HOST'] . "/redefinir.php?token=" . $token;

        // Monta E-mail
        $assunto = "Redefinir Senha";
        $mensagem = "
        <div style='font-family: Arial, sans-serif; background: #f4f4f4; padding: 20px;'>
            <div style='background: #fff; max-width: 500px; margin: 0 auto; padding: 30px; border-radius: 8px; border: 1px solid #ddd;'>
                <h2 style='color: #333; margin-top: 0;'>Recuperação de Senha</h2>
                <p>Olá, <strong>{$user['nome']}</strong>.</p>
                <p>Recebemos uma solicitação para redefinir sua senha.</p>
                <p>Clique no botão abaixo para criar uma nova senha:</p>
                <br>
                <center>
                    <a href='$link' style='background: #ff0050; color: #fff; padding: 12px 25px; text-decoration: none; border-radius: 5px; font-weight: bold; display: inline-block;'>REDEFINIR SENHA</a>
                </center>
                <br><br>
                <p style='font-size: 12px; color: #999;'>Link válido por 1 hora. Se não foi você, ignore.</p>
            </div>
        </div>
        ";

        // TENTA ENVIAR USANDO O NOVO MOTOR SMTP
        $envio = enviarEmailSMTP($email, $assunto, $mensagem);

        if ($envio === true) {
            $msg = "Link enviado! Verifique seu e-mail (e a caixa de spam).";
        } else {
            // Mostra erro detalhado se falhar (para você saber se a senha do email ta errada)
            $erro = "Erro no envio: " . $envio;
        }

    } else {
        // Mensagem de segurança (mesmo se não existir)
        $msg = "Se o e-mail estiver cadastrado, você receberá o link.";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recuperar Senha</title>
    <link rel="icon" href="https://www.tiktok.com/favicon.ico" type="image/x-icon" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #000; color: #fff; }
        .login-bg { background-image: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.9)), url('https://images.unsplash.com/photo-1451187580459-43490279c0fa?q=80&w=2072&auto=format&fit=crop'); background-size: cover; background-position: center; }
    </style>
</head>
<body class="login-bg h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md bg-black/85 p-10 rounded-xl border border-gray-800 backdrop-blur-md">
        <h1 class="text-2xl font-bold mb-2">Esqueceu a senha?</h1>
        <p class="text-gray-400 text-sm mb-6">Digite seu e-mail para receber o link.</p>

        <?php if($msg): ?>
            <div class="bg-green-500/20 text-green-200 p-3 rounded mb-4 text-sm text-center border border-green-500/30">
                <?= $msg ?>
            </div>
        <?php endif; ?>
        
        <?php if($erro): ?>
            <div class="bg-red-500/20 text-red-200 p-3 rounded mb-4 text-xs text-center border border-red-500/30 break-words">
                <?= $erro ?>
                <br><br>
                <span class="font-bold">Dica:</span> Vá no Painel Admin > Configurações e verifique se o E-mail e Senha do SMTP estão corretos.
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-4">
            <div>
                <input type="email" name="email" placeholder="Seu e-mail de cadastro" required class="w-full bg-[#333] border border-transparent focus:border-[#ff0050] text-white rounded p-3 outline-none transition">
            </div>
            <button class="w-full bg-[#ff0050] hover:bg-[#d60043] text-white font-bold py-3 rounded transition">ENVIAR LINK</button>
        </form>
        
        <div class="mt-6 text-center">
            <a href="area_aluno.php" class="text-sm text-gray-400 hover:text-white transition">Voltar para o Login</a>
        </div>
    </div>
</body>
</html>